Rem
Rem $Header: pc.sql 14-jun-2007.17:27:06 rkothuri Exp $
Rem
Rem pc.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      pc.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkothuri    06/04/07 - add error explanation
Rem    rkothuri    01/30/07 - Examples for Creating and Querying a PointCloud. 
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- Delete from base table. This also deletes from blktab.
delete from base;
select count(*) from blktab;

-- 
drop table base;

-- Blktab cannot be dropped before base table is dropped.
drop table blktab;
drop table res;
drop table inptab;
drop table lidar_data;
delete from user_sdo_geom_metadata;
drop table restst;


-- Recreate the database
-- Create input data. 
create table lidar_data (id       number,
                         geometry sdo_geometry);


declare
  curr_lon  number;
  curr_lat  number;
  increment number := .000001;
  id        number;
begin
  id := 1;
  for lat in 40 .. 40 loop
    curr_lat := lat;
    for lon in -74 .. -74 loop
      --
      -- Create 1 million points per 1x1 degree cell
      --
      for i in 1 .. 10 loop
        curr_lon := lon;
        for j in 1 .. 10 loop
          insert into lidar_data values (id,
                                         sdo_geometry (3001, null,
                                                       sdo_point_type (curr_lon,curr_lat,
                                                                       mod (abs (dbms_random.random), 100)),
                                                       null, null));
          curr_lon := curr_lon + increment;
          id := id + 1;
        end loop;
        curr_lat := curr_lat + increment;
      end loop;
    end loop;
  end loop;
end;
/
commit;

--  INPTAB contains the input data for the PointCloud.
-- This is the input table. 
-- The input table is always of the form
-- rid varchar2(24), val_d1, val_d2,... val_dn numbers
-- where "n" is the total_dimensionality of the PointCloud.
CREATE TABLE inptab NOLOGGING AS
  SELECT TO_CHAR(a.id)          rid,
         a.geometry.sdo_point.x val_d1,
         a.geometry.sdo_point.y val_d2,
         a.geometry.sdo_point.z val_d3
  FROM lidar_data a;



-- Create 'base' table containing pointcloud column.
create table base (pc sdo_pc);

-- Create block table to store the blocks of the pointcloud. 
-- Block table is always created as select * from mdsys.sdo_pc_blk_table.
create table blktab as select * from mdsys.sdo_pc_blk_table;


-- This is the result table .
-- This table should have the same attributes as INPTAB
-- but with two additional columns ptn_id and point_id. 
create table res (ptn_id number, point_id number,
rid varchar2(24), val_d1 number, val_d2 number, val_d3 number);

truncate table res;
truncate table blktab;

-- Initialize a PointCloud object and populate it using the points in INPTAB. 
declare
  pc sdo_pc;
begin
  -- Initialize the Point Cloud object. 
  pc := sdo_pc_pkg.init(
          'BASE', -- Table that has the SDO_POINT_CLOUD column defined
          'PC',   -- Column name of the SDO_POINT_CLOUD object 
          'BLKTAB', -- Table to store blocks of the point cloud
           'blk_capacity=50', -- max # of points per block 
           mdsys.sdo_geometry(2003, 8307, null,
              mdsys.sdo_elem_info_array(1,1003,3),
              mdsys.sdo_ordinate_array(-180, -90, 180, 90)),  -- Extent 
	   0.5, -- Tolerance for point cloud
           3, -- Total number of dimensions
           null);

  -- Insert the Point Cloud object  into the "base" table.
  insert into base values (pc);

  -- Create the blocks for the point cloud.
  sdo_pc_pkg.create_pc(
    pc,       -- Initialized PointCloud object
    'INPTAB', -- Name of input table to ingest into the pointcloud
    'RES'     -- Name of output table that stores the points (with ptn_id,pt_id)
  );
end;
/
-- Point Cloud is created.
                                                                                  
-- PointCloud may not be created if there are scratch tables from previous run
-- of an aborted creation. A subsequent Point Cloud creation using
-- above script may result in the following errors.
-- "ORA-13199: Rerun after cleaning up using sdo_util.drop_work_tables('F337')
--  ORA-54605: CREATE_PC: scratch tables/views(M%_1_F337$$%) exist ..."
-- The following actions need to be performed based on these error messages.
-- SQL> exec sdo_util.drop_work_tables('F337');
-- The 54605 error msg also contains the pcid as M%_<pcid>_F337$$%,
-- i.e., pcid=1. One can delete the PC from base table where pc_id=<pcid>.
-- SQL> delete from base a where a.pc_id=1;
-- SQL> commit;
-- The above creation script can then be rerun for successful creation.



-- Return points in blk_id of the Point Cloud as a multi-point collection.
select sdo_pc_pkg.to_geometry(
		    a.points,   -- point LOB
                    a.num_points, -- # of points in the LOB
                    3,  -- total dimensionality
		    8307 -- SRID
	          ) from blktab a where blk_id=0;


-- Clip the point cloud with a specific geometry.
-- Create a table to store results of a CLIP_PC operation.
create table restst as select * from mdsys.sdo_pc_blk_table;

declare
  inp  sdo_pc;
begin
  select pc INTO inp  from base where rownum=1;
  insert into restst
  select * from
    table(sdo_pc_pkg.clip_pc
	  (
            inp,  -- Input Point Cloud object
            sdo_geometry(2003, 8307, null,
              mdsys.sdo_elem_info_array(1, 1003, 3),
              mdsys.sdo_ordinate_array(-74.1, -73.9, 39.99999,40.00001)), -- Query 
	    null, null, null, null));
end;
/
select num_points, blk_id from restst order by blk_id;

-- Get the points in each block as a multi-point collection SDO_GEOMETRY. 
select sdo_pc_pkg.to_geometry(
	            a.points,   -- LOB containing the points
                    a.num_points, -- # of points in the LOB
                    3, -- Total dimensionality of the points in the LOB
	            8307 -- SRID
	          ) from restst a where num_points>0;
                                                                                

-- Get the points in each block as a multi-point collection SDO_GEOMETRY.
select sdo_pc_pkg.get_pt_ids(
                    a.points,   -- LOB containing the points
                    a.num_points, -- # of points in the LOB
                    3 -- Total dimensionality of the points in the LOB
                  ) from restst a where num_points >0;


select ptn_id, min(point_id), max(point_id) from res group by ptn_id;

-- Cleanup

exit;
